<?php
// Configuration
$apiUrl = 'https://prixsmm.com/adminapi/v2/tickets?status=pending';
$apiKey = '4xcqonled2d2sgr7aimfe8x547gh6y0i6qbjgbicweg6fgkbio2aendaohxtf2r3';
$logFile = 'logfile.log';
$dbHost = 'localhost';
$dbUser = 'ysteam_f6tickets';
$dbPass = 'ysteam_f6tickets';
$dbName = 'ysteam_f6tickets';

// Set up logging function
function logMessage($message) {
    global $logFile;
    file_put_contents($logFile, date('Y-m-d H:i:s') . ' - ' . $message . PHP_EOL, FILE_APPEND);
}

// Fetch data from the API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'X-Api-Key: ' . $apiKey
]);
$response = curl_exec($ch);
if (curl_errno($ch)) {
    logMessage('cURL error: ' . curl_error($ch));
    exit;
}
curl_close($ch);

// Decode the JSON response
$data = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    logMessage('JSON decode error: ' . json_last_error_msg());
    exit;
}

// Check for errors in the API response
if (isset($data['error_code']) && $data['error_code'] !== 0) {
    logMessage('API error: ' . $data['error_message']);
    exit;
}

// Connect to the database
$mysqli = new mysqli($dbHost, $dbUser, $dbPass, $dbName);
if ($mysqli->connect_error) {
    logMessage('Database connection error: ' . $mysqli->connect_error);
    exit;
}

// Prepare the SQL statement
$stmt = $mysqli->prepare('
    INSERT INTO tickets (ticket_id, username, subject, status, assignee, created, last_update, is_read)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
        username = VALUES(username),
        subject = VALUES(subject),
        status = VALUES(status),
        assignee = VALUES(assignee),
        created = VALUES(created),
        last_update = VALUES(last_update),
        is_read = VALUES(is_read)
');
if (!$stmt) {
    logMessage('Prepare statement error: ' . $mysqli->error);
    exit;
}

// Bind parameters
$stmt->bind_param('issssssi', $ticketId, $username, $subject, $status, $assignee, $created, $lastUpdate, $isRead);

// Process each ticket
foreach ($data['data']['list'] as $ticket) {
    $ticketId = $ticket['id'];
    $username = $ticket['user']['username'];
    $subject = $ticket['subject'];
    $status = $ticket['status'];
    $assignee = $ticket['assignee'] ?? null;
    $created = $ticket['created'];
    $lastUpdate = $ticket['last_update'];
    $isRead = $ticket['is_read'] ? 1 : 0;

    // Execute the statement
    if ($stmt->execute()) {
        logMessage("Successfully inserted/updated ticket ID $ticketId.");
    } else {
        logMessage("Error inserting/updating ticket ID $ticketId: " . $stmt->error);
    }
}

// Close the statement and connection
$stmt->close();
$mysqli->close();
?>
