<?php

// Database credentials
define('DB_HOST', 'localhost');
define('DB_USER', 'ysteam_f6tickets');
define('DB_PASSWORD', 'ysteam_f6tickets');
define('DB_NAME', 'ysteam_f6tickets');

// API credentials
define('API_KEY', '4xcqonled2d2sgr7aimfe8x547gh6y0i6qbjgbicweg6fgkbio2aendaohxtf2r3');

// Connect to the database
function connectDB() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
    if ($conn->connect_error) {
        die("Database connection failed: " . $conn->connect_error);
    }
    return $conn;
}

// Fetch pending tickets from the API
function fetchPendingTickets() {
    $url = "https://prixsmm.com/adminapi/v2/tickets?status=pending";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-Api-Key: ' . API_KEY
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        error_log("cURL error: " . curl_error($ch));
        curl_close($ch);
        return null;
    }

    curl_close($ch);

    // Log the raw API response
    error_log("API Response: " . $response);

    return json_decode($response, true);
}

// Fetch ticket details by ticket ID
function fetchTicketDetails($ticketId) {
    $url = "https://prixsmm.com/adminapi/v2/tickets/" . $ticketId;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-Api-Key: ' . API_KEY
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        error_log("cURL error: " . curl_error($ch));
        curl_close($ch);
        return null;
    }

    curl_close($ch);
    return json_decode($response, true);
}

// Store ticket and messages in the database
function storeTicketAndMessages($ticketData) {
    $conn = connectDB();

    // Prepare ticket data
    $ticketId = $ticketData['id'];
    $username = $ticketData['user']['username'];
    $subject = $ticketData['subject'];
    $status = $ticketData['status'];
    $assignee = isset($ticketData['assignee']) ? $ticketData['assignee'] : NULL;
    $created = $ticketData['created'];
    $lastUpdate = $ticketData['last_update'];
    $isRead = $ticketData['is_read'] ? 1 : 0;

    // Insert or update ticket
    $stmt = $conn->prepare("
        INSERT INTO tickets (id, username, subject, status, assignee, created, last_update, is_read)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
        username = VALUES(username),
        subject = VALUES(subject),
        status = VALUES(status),
        assignee = VALUES(assignee),
        created = VALUES(created),
        last_update = VALUES(last_update),
        is_read = VALUES(is_read)
    ");

    $stmt->bind_param("issssssi", $ticketId, $username, $subject, $status, $assignee, $created, $lastUpdate, $isRead);

    if ($stmt->execute()) {
        error_log("Ticket ID $ticketId stored successfully.");
    } else {
        error_log("Error storing ticket ID $ticketId: " . $stmt->error);
    }

    $stmt->close();

    // Prepare and insert messages
    if (isset($ticketData['messages']) && is_array($ticketData['messages'])) {
        foreach ($ticketData['messages'] as $message) {
            $messageContent = $message['message'];
            $senderName = $message['sender_name'];
            $isStaff = $message['is_staff'] ? 1 : 0;
            $isUnread = $message['is_unread'] ? 1 : 0;
            $messageCreated = $message['created'];

            $stmt = $conn->prepare("
                INSERT IGNORE INTO ticket_messages (ticket_id, message, sender_name, is_staff, is_unread, created)
                VALUES (?, ?, ?, ?, ?, ?)
            ");

            $stmt->bind_param("isssis", $ticketId, $messageContent, $senderName, $isStaff, $isUnread, $messageCreated);

            if ($stmt->execute()) {
                if ($stmt->affected_rows > 0) {
                    error_log("Message for Ticket ID $ticketId stored successfully.");
                } else {
                    error_log("Duplicate message for Ticket ID $ticketId detected; skipping insertion.");
                }
            } else {
                error_log("Error storing message for Ticket ID $ticketId: " . $stmt->error);
            }

            $stmt->close();
        }
    }

    $conn->close();
}

// Main execution
$pendingTickets = fetchPendingTickets();

if ($pendingTickets && isset($pendingTickets['data']['list'])) {
    foreach ($pendingTickets['data']['list'] as $ticket) {
        $ticketId = $ticket['id'];
        $ticketDetails = fetchTicketDetails($ticketId);

        if ($ticketDetails && isset($ticketDetails['data'])) {
            storeTicketAndMessages($ticketDetails['data']);
        } else {
            error_log("Failed to retrieve details for Ticket ID $ticketId");
        }
    }
} else {
    error_log("No pending tickets found or failed to retrieve pending tickets.");
}

?>
